package com.yd.csf.service.model;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import java.io.Serializable;
import java.time.LocalDateTime;
import lombok.Getter;
import lombok.Setter;

/**
 * <p>
 * 管理关系表（（团队的形成来自这张表，谁在最高级就是团长））
 * </p>
 *
 * @author zxm
 * @since 2025-10-21
 */
@Getter
@Setter
@TableName("agent_manage_relation")
public class AgentManageRelation implements Serializable {

    private static final long serialVersionUID = 1L;

    /**
     * 主键ID
     */
    @TableId(value = "id", type = IdType.AUTO)
    private Long id;

    /**
     * 管理关系表唯一业务ID
     */
    @TableField("manage_biz_id")
    private String manageBizId;

    /**
     * 被管理人ID（客户端用户表唯一业务ID）
     */
    @TableField("agent_id")
    private String agentId;

    /**
     * 管理人ID（客户端用户表唯一业务ID，是被管理人的一级管理人）
     */
    @TableField("manage_id")
    private String manageId;

    /**
     * 管理路径(用于快速查询关系链)
     */
    @TableField("manage_path")
    private String managePath;

    /**
     * 是否有效(0:否 1:是)
     */
    @TableField("is_active")
    private Integer isActive;

    /**
     * 所属租户唯一业务ID（冗余）
     */
    @TableField("tenant_biz_id")
    private String tenantBizId;

    /**
     * 所属项目唯一业务ID（冗余）
     */
    @TableField("project_biz_id")
    private String projectBizId;

    /**
     * 通用备注
     */
    @TableField("remark")
    private String remark;

    /**
     * 删除标识: 0-正常, 1-删除
     */
    @TableField("is_deleted")
    private Integer isDeleted;

    /**
     * 创建人ID
     */
    @TableField("creator_id")
    private String creatorId;

    /**
     * 更新人ID
     */
    @TableField("updater_id")
    private String updaterId;

    /**
     * 创建时间
     */
    @TableField("create_time")
    private LocalDateTime createTime;

    /**
     * 更新时间
     */
    @TableField("update_time")
    private LocalDateTime updateTime;
}
