package com.yd.csf.service.model;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import java.io.Serializable;
import java.time.LocalDateTime;
import lombok.Getter;
import lombok.Setter;

/**
 * <p>
 * 车辆预约申请表
 * </p>
 *
 * @author zxm
 * @since 2025-10-15
 */
@Getter
@Setter
@TableName("car_apply")
public class CarApply implements Serializable {

    private static final long serialVersionUID = 1L;

    /**
     * 主键ID
     */
    @TableId(value = "id", type = IdType.AUTO)
    private Long id;

    /**
     * 车辆预约申请表唯一业务ID
     */
    @TableField("apply_biz_id")
    private String applyBizId;

    /**
     * 预约信息主表唯一业务ID
     */
    @TableField("appointment_biz_id")
    private String appointmentBizId;

    /**
     * 客户端用户表唯一业务ID（业务员）
     */
    @TableField("member_biz_id")
    private String memberBizId;

    /**
     * 司机姓名
     */
    @TableField("driver_name")
    private String driverName;

    /**
     * 司机电话
     */
    @TableField("driver_telephone")
    private String driverTelephone;

    /**
     * 车辆类型（字典：专车、顺风车）
     */
    @TableField("vehicle_type")
    private String vehicleType;

    /**
     * 车牌号
     */
    @TableField("car_no")
    private String carNo;

    /**
     * 客户表唯一业务ID
     */
    @TableField("customer_biz_id")
    private String customerBizId;

    /**
     * 客户类型（签单客户、非签单客户）
     */
    @TableField("customer_type")
    private String customerType;

    /**
     * 客户姓名
     */
    @TableField("customer_name")
    private String customerName;

    /**
     * 申请人
     */
    @TableField("applicant")
    private String applicant;

    /**
     * 接送日期
     */
    @TableField("send_date")
    private LocalDateTime sendDate;

    /**
     * 接送时间
     */
    @TableField("send_time")
    private LocalDateTime sendTime;

    /**
     * 申请状态（待审批，初审通过、初审驳回、复核通过、复核驳回、预约确认、终审驳回、已过期、已取消、已完成）
     */
    @TableField("status")
    private String status;

    /**
     * 所属租户唯一业务ID（冗余）
     */
    @TableField("tenant_biz_id")
    private String tenantBizId;

    /**
     * 所属项目唯一业务ID（冗余）
     */
    @TableField("project_biz_id")
    private String projectBizId;

    /**
     * 通用备注
     */
    @TableField("remark")
    private String remark;

    /**
     * 删除标识: 0-正常, 1-删除
     */
    @TableField("is_deleted")
    private Integer isDeleted;

    /**
     * 创建人ID
     */
    @TableField("creator_id")
    private String creatorId;

    /**
     * 更新人ID
     */
    @TableField("updater_id")
    private String updaterId;

    /**
     * 创建时间
     */
    @TableField("create_time")
    private LocalDateTime createTime;

    /**
     * 更新时间
     */
    @TableField("update_time")
    private LocalDateTime updateTime;
}
