package com.yd.csf.service.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.yd.csf.service.model.AppointmentLog;
import com.yd.csf.service.dao.AppointmentLogMapper;
import com.yd.csf.service.service.IAppointmentLogService;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import org.springframework.stereotype.Service;

/**
 * <p>
 * 预约信息日志表（快照表） 服务实现类
 * </p>
 *
 * @author zxm
 * @since 2025-12-15
 */
@Service
public class AppointmentLogServiceImpl extends ServiceImpl<AppointmentLogMapper, AppointmentLog> implements IAppointmentLogService {

    @Override
    public AppointmentLog queryOne(String appointmentLogBizId) {
        return this.getOne(new LambdaQueryWrapper<AppointmentLog>().eq(AppointmentLog::getAppointmentLogBizId,appointmentLogBizId));
    }
}
