package com.yd.csf.service.service.impl;

import cn.hutool.core.collection.CollUtil;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.yd.csf.feign.request.expectedfortune.ApiExpectedFortunePageRequest;
import com.yd.csf.feign.response.expectedfortune.ApiExpectedFortunePageResponse;
import com.yd.csf.feign.response.expectedfortune.PolicyInfo;
import com.yd.csf.service.model.ExpectedFortune;
import com.yd.csf.service.dao.ExpectedFortuneMapper;
import com.yd.csf.service.model.Policy;
import com.yd.csf.service.service.IExpectedFortuneService;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.yd.csf.service.service.PolicyService;
import com.yd.csf.service.vo.ExpectedFortuneStatisticsVO;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;

/**
 * <p>
 * 预计发佣表 服务实现类
 * </p>
 *
 * @author zxm
 * @since 2025-11-17
 */
@Service
public class ExpectedFortuneServiceImpl extends ServiceImpl<ExpectedFortuneMapper, ExpectedFortune> implements IExpectedFortuneService {

    @Resource
    private PolicyService policyService;

    @Override
    public IPage<ApiExpectedFortunePageResponse> page(Page<ApiExpectedFortunePageResponse> page,
                                                      ApiExpectedFortunePageRequest request) {
        return baseMapper.page(page, request);
    }

    @Override
    public List<ExpectedFortune> listByPolicyBizId(String policyBizId) {
        return baseMapper.listByPolicyBizId(policyBizId);
    }

    /**
     * 查询列表
     *
     * @param policyNo
     * @return
     */
    @Override
    public List<ExpectedFortune> queryList(String policyNo) {
        return baseMapper.selectList(new LambdaQueryWrapper<ExpectedFortune>().eq(ExpectedFortune::getPolicyNo, policyNo));
    }

    @Override
    public Boolean batchDelByPolicyNo(String policyNo) {
        return this.remove(new LambdaQueryWrapper<ExpectedFortune>().eq(ExpectedFortune::getPolicyNo, policyNo));
    }

    @Override
    public ExpectedFortuneStatisticsVO getStatistics(List<Long> expectedFortuneIds) {
        return baseMapper.getStatistics(expectedFortuneIds);
    }

    @Override
    public IPage<ApiExpectedFortunePageResponse> getVOPage(IPage<ExpectedFortune> iPage) {
        List<ExpectedFortune> expectedFortuneList = iPage.getRecords();
        Page<ApiExpectedFortunePageResponse> expectedFortuneVOPage = new Page<>(iPage.getCurrent(), iPage.getSize(), iPage.getTotal());
        if (CollUtil.isEmpty(expectedFortuneList)) {
            return expectedFortuneVOPage;
        }
        List<ApiExpectedFortunePageResponse> expectedFortuneVOList = toVOList(expectedFortuneList);
        expectedFortuneVOPage.setRecords(expectedFortuneVOList);
        return expectedFortuneVOPage;
    }

    @Override
    public List<ApiExpectedFortunePageResponse> toVOList(List<ExpectedFortune> expectedFortuneList) {
        // 关联保单信息
        List<Policy> policyList = policyService.lambdaQuery()
                .in(Policy::getPolicyNo, expectedFortuneList.stream().map(ExpectedFortune::getPolicyNo).collect(Collectors.toList()))
                .list();
        Map<String, Policy> policyMap = policyList.stream()
                .collect(Collectors.toMap(Policy::getPolicyNo, Function.identity()));

        List<ApiExpectedFortunePageResponse> expectedFortuneVOList = expectedFortuneList.stream().map(expectedFortune -> {
            ApiExpectedFortunePageResponse expectedFortuneVO = new ApiExpectedFortunePageResponse();
            BeanUtils.copyProperties(expectedFortune, expectedFortuneVO);

            Policy policy = policyMap.get(expectedFortune.getPolicyNo());
            if (policy != null) {
                expectedFortuneVO.setInsuranceCompany(policy.getInsuranceCompany());
                expectedFortuneVO.setProductName(policy.getProductName());
                expectedFortuneVO.setPremium(policy.getPaymentPremium());
            }
            return expectedFortuneVO;
        }).collect(Collectors.toList());
        return expectedFortuneVOList;
    }
}
