package com.yd.csf.feign.response.ruleItemconfig;

import com.yd.csf.feign.dto.formulaconfig.ApiFormulaConfigDto;
import lombok.Data;
import java.time.LocalDateTime;

@Data
public class ApiRuleItemConfigDetailResponse {

    /**
     * 主键ID
     */
    private Long id;

    /**
     * 基本法项目配置表唯一业务ID
     */
    private String ruleItemBizId;

    /**
     * 基本法配置表唯一业务ID
     */
    private String ruleBizId;

    /**
     * 基本法项目编码
     */
    private String itemCode;

    /**
     * 基本法项目名称
     */
    private String itemName;

    /**
     * 计算时间点（字典）
     */
    private String calculate;

    /**
     * 执行顺序，数值越小越先执行，用于控制佣金项目的计算顺序
     */
    private Integer executionOrder;

    /**
     * 项目描述
     */
    private String description;

    /**
     * 状态(0:停用 1:启用)
     */
    private Integer status;

    /**
     * 通用备注
     */
    private String remark;

    /**
     * 删除标识: 0-正常, 1-删除
     */
    private Integer isDeleted;

    /**
     * 创建人ID
     */
    private String creatorId;

    /**
     * 更新人ID
     */
    private String updaterId;

    /**
     * 创建时间
     */
    private LocalDateTime createTime;

    /**
     * 更新时间
     */
    private LocalDateTime updateTime;

    /**
     * 绑定的公式对象
     */
    private ApiFormulaConfigDto apiFormulaConfigDto;
}
