package com.yd.csf.api.dto;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;
import java.util.List;

/**
 * 生成业务员（转介人）积分明细表记录入参
 */
@Data
@Builder
@NoArgsConstructor
@AllArgsConstructor
public class GenerateAgentDetailFycDto {

    /**
     * 获得积分的业务员（客户端用户唯一业务ID）
     */
    private String agentId;

    /**
     * 提供积分来源类型：保单转介费、一级管理奖、二级管理奖、辅导津贴奖、终身推荐奖
     */
    private String sourceType;

    /**
     * 提供积分的业务员（客户端用户唯一业务ID）
     */
    private String provider;

    /**
     * 提供积分的保单号
     */
    private String policyNo;

    /**
     * 提供积分的保单发佣批次ID
     */
    private String batchBizId;

    /**
     * 获得积分的业务员绑定的基本法列表（基本法计算值列表）
     */
    private List<AlgorithmResDto> algorithmResDtoList;
}
