package com.yd.csf.feign.response.additional;

import lombok.Data;

import java.math.BigDecimal;

@Data
public class ApiAdditionalPageResponse {

    /**
     * 附加险信息表主键id
     */
    private Long id;

    /**
     * 附加险信息表唯一业务ID
     */
    private String additionalBizId;

    /**
     * 产品计划信息表唯一业务ID
     */
    private String planBizId;

    /**
     * 保险附加产品唯一业务ID（中台保险附加产品业务id，冗余）
     */
    private String additionalProductBizId;

    /**
     * 保险附加产品名称（中台保险附加产品名称，冗余）
     */
    private String productName;

    /**
     * 货币（字典）
     */
    private String currency;

    /**
     * 保费
     */
    private BigDecimal premium;

    /**
     * 保额
     */
    private BigDecimal sumInsured;

    /**
     * 保障地区（字典）
     */
    private String guaranteeRegion;

    /**
     * 等级（字典）
     */
    private String level;

    /**
     * 自付额（字典）
     */
    private String deductibles;

    /**
     * 附加保障（json串）
     */
    private String additionalSafeguards;
}
