package com.yd.csf.service.dto;

import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;
import java.util.List;

@Data
public class PolicyFollowUpdateDto implements Serializable {
    private static final long serialVersionUID = 1L;

    /**
     * 新单编号
     */
    @Schema(description = "新单编号", requiredMode = Schema.RequiredMode.REQUIRED)
    private String policyBizId;

    /**
     * 客户编号
     */
    @Schema(description = "客户编号")
    private String customerBizId;

    /**
     * 签单日期
     */
    @Schema(description = "签单日期", format = "yyyy-MM-dd")
    @JsonFormat(pattern = "yyyy-MM-dd")
    private Date signDate;

    /**
     * 签单员
     */
    @Schema(description = "签单员")
    private PolicySigner signer;

    /**
     * 签单员执业编号
     */
    @Schema(description = "签单员执业编号")
    private String signerRegNo;

    /**
     * 签单地点
     */
    @Schema(description = "签单地点")
    private String signLocation;

    /**
     * 保单号
     */
    @Schema(description = "保单号")
    private String policyNo;

    /**
     * 产品计划业务id
     */
    @Schema(description = "产品计划业务id")
    private String productLaunchBizId;

    /**
     * 产品名称
     */
    @Schema(description = "产品名称")
    private String productName;

    /**
     * 冷静期天数
     */
    @Schema(description = "冷静期天数")
    private Integer coolingOffDays;

    /**
     * 冷静期结束日期
     */
    @Schema(description = "冷静期结束日期", format = "yyyy-MM-dd")
    @JsonFormat(pattern = "yyyy-MM-dd")
    private Date coolingOffEndDate;

    /**
     * 生效日期
     */
    @Schema(description = "生效日期", format = "yyyy-MM-dd")
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date effectiveDate;

    /**
     * 续保日期
     */
    @Schema(description = "续保日期", format = "yyyy-MM-dd")
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date renewalDate;




    /**
     * 产品类别
     */
    @Schema(description = "产品类别")
    private String productCate;

    /**
     * 保险公司
     */
    @Schema(description = "保险公司")
    private String insuranceCompany;

    /**
     * 保险公司业务id
     */
    @Schema(description = "保险公司业务id")
    private String insuranceCompanyBizId;

    /**
     * 对账公司
     */
    @Schema(description = "对账公司")
    private String reconciliationCompany;

    /**
     * 对账公司业务id
     */
    @Schema(description = "对账公司业务id")
    private String reconciliationCompanyBizId;

    /**
     * 保單持有人
     */
    @Schema(description = "保單持有人")
    private String policyHolder;

    /**
     * 受保人
     */
    @Schema(description = "受保人")
    private String insured;

    /**
     * 受保人业务id
     */
    @Schema(description = "受保人业务id")
    private String insuredBizId;

    /**
     * 保单币种
     */
    @Schema(description = "保单币种")
    private String policyCurrency;


}
