package com.yd.csf.service.model;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import java.io.Serializable;
import java.time.LocalDateTime;
import lombok.Getter;
import lombok.Setter;

/**
 * <p>
 * 邀请码表
 * </p>
 *
 * @author zxm
 * @since 2025-10-15
 */
@Getter
@Setter
@TableName("invitation")
public class Invitation implements Serializable {

    private static final long serialVersionUID = 1L;

    /**
     * 主键ID
     */
    @TableId(value = "id", type = IdType.AUTO)
    private Long id;

    /**
     * 邀请码表唯一业务ID
     */
    @TableField("invitation_biz_id")
    private String invitationBizId;

    /**
     * 邀请类型（字典：OPEN_ACCOUNT-开通账号，RECOMMEND-推荐，辅导-TUTORING）
     */
    @TableField("invitation_type")
    private String invitationType;

    /**
     * 邀请人（客户端用户表唯一业务ID）
     */
    @TableField("inviter")
    private String inviter;

    /**
     * 被邀请人（客户端用户表唯一业务ID）
     */
    @TableField("invitee")
    private String invitee;

    /**
     * 邀请码
     */
    @TableField("invitation_code")
    private String invitationCode;

    /**
     * 状态(0:停用 1:启用)
     */
    @TableField("status")
    private Integer status;

    /**
     * 所属租户唯一业务ID（冗余）
     */
    @TableField("tenant_biz_id")
    private String tenantBizId;

    /**
     * 所属项目唯一业务ID（冗余）
     */
    @TableField("project_biz_id")
    private String projectBizId;

    /**
     * 通用备注
     */
    @TableField("remark")
    private String remark;

    /**
     * 删除标识: 0-正常, 1-删除
     */
    @TableField("is_deleted")
    private Integer isDeleted;

    /**
     * 创建人ID
     */
    @TableField("creator_id")
    private String creatorId;

    /**
     * 更新人ID
     */
    @TableField("updater_id")
    private String updaterId;

    /**
     * 创建时间
     */
    @TableField("create_time")
    private LocalDateTime createTime;

    /**
     * 更新时间
     */
    @TableField("update_time")
    private LocalDateTime updateTime;
}
