package com.yd.csf.service.dto;

import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;

@Data
public class PolicyPolicyholderUpdateRequest implements Serializable {

    private static final long serialVersionUID = 1L;

    /**
     * 保单投保人信息表唯一业务ID
     */
    @Schema(description = "保单投保人信息表唯一业务ID", requiredMode = Schema.RequiredMode.REQUIRED)
    private String policyPolicyholderBizId;

    /**
     * 保单号
     */
    @Schema(description = "保单号")
    private String policyNo;

    /**
     * 客户类型（字典）
     */
    @Schema(description = "客户类型（字典）")
    private String customerType;

    /**
     * 关联客户信息表唯一业务ID（冗余字段）
     */
    @Schema(description = "关联客户信息表唯一业务ID（冗余字段）")
    private String customerBizId;

    /**
     * 关联客户编号（和客户信息表唯一业务ID是一对，唯一，冗余字段）
     */
    @Schema(description = "关联客户编号（和客户信息表唯一业务ID是一对，唯一，冗余字段）")
    private String customerNo;

    /**
     * 名字
     */
    @Schema(description = "名字")
    private String name;

    /**
     * 名字-英文
     */
    @Schema(description = "名字-英文")
    private String nameEn;

    /**
     * 性别（字典）
     */
    @Schema(description = "性别（字典）")
    private String gender;

    /**
     * 证件类型（字典）
     */
    @Schema(description = "证件类型（字典）")
    private String documentType;

    /**
     * 证件号码
     */
    @Schema(description = "证件号码")
    private String idNumber;

    /**
     * 出生日期
     */
    @Schema(description = "出生日期")
    private Date birthday;

    /**
     * 年龄
     */
    @Schema(description = "年龄")
    private String age;

    /**
     * 居住地址
     */
    @Schema(description = "居住地址")
    private String residentialAddress;

    /**
     * 通讯地址
     */
    @Schema(description = "通讯地址")
    private String mailingAddress;

    /**
     * 移动电话区号
     */
    @Schema(description = "移动电话区号")
    private String mobileCode;

    /**
     * 移动电话
     */
    @Schema(description = "移动电话")
    private String mobile;

    /**
     * 邮箱
     */
    @Schema(description = "邮箱")
    private String email;

    /**
     * 公司名称
     */
    @Schema(description = "公司名称")
    private String companyName;

    /**
     * 公司地址
     */
    @Schema(description = "公司地址")
    private String companyAddress;

    /**
     * 行业
     */
    @Schema(description = "行业")
    private String industry;

    /**
     * 职位
     */
    @Schema(description = "职位")
    private String position;

    /**
     * 风险偏好（字典）
     */
    @Schema(description = "风险偏好（字典）")
    private String riskAppetite;

    /**
     * 是否VIP: 0-否, 1-是（字典）
     */
    @Schema(description = "是否VIP: 0-否, 1-是（字典）")
    private Integer isVip;

    /**
     * vip备注
     */
    @Schema(description = "vip备注")
    private String vipRemark;

    /**
     * 称谓（字典）
     */
    @Schema(description = "称谓（字典）")
    private String appellation;

    /**
     * 是否区分吸烟（字典）
     */
    @Schema(description = "是否区分吸烟（字典）")
    private String smokingAllowed;

    /**
     * 出生地（省市）
     */
    @Schema(description = "出生地（省市）")
    private String birthplace;

    /**
     * 国籍
     */
    @Schema(description = "国籍")
    private String nationality;

    /**
     * 护照号码
     */
    @Schema(description = "护照号码")
    private String passportNo;

    /**
     * 通行证号码
     */
    @Schema(description = "通行证号码")
    private String passNo;

    /**
     * 身高
     */
    @Schema(description = "身高")
    private String height;

    /**
     * 体重
     */
    @Schema(description = "体重")
    private String weight;

    /**
     * BMI
     */
    @Schema(description = "BMI")
    private String bmi;

    /**
     * 平均每月支出
     */
    @Schema(description = "平均每月支出")
    private BigDecimal monthExpenditure;

    /**
     * 平均每月收入
     */
    @Schema(description = "平均每月收入")
    private BigDecimal monthIncome;

    /**
     * 受雇于现职年期
     */
    @Schema(description = "受雇于现职年期")
    private BigDecimal currentTenure;

    /**
     * 总流动资产
     */
    @Schema(description = "总流动资产")
    private BigDecimal totalCurrentAssets;

    /**
     * 总负债额
     */
    @Schema(description = "总负债额")
    private BigDecimal totalDebt;

    /**
     * 受供养人数目
     */
    @Schema(description = "受供养人数目")
    private Integer dependentsNum;

    /**
     * 婚姻状况（字典）
     */
    @Schema(description = "婚姻状况（字典）")
    private String maritalStatus;

    /**
     * 教育程度（字典）
     */
    @Schema(description = "教育程度（字典）")
    private String educationLevel;

    /**
     * 总工作年期
     */
    @Schema(description = "总工作年期")
    private BigDecimal totalWorkingYears;

    /**
     * 现时每月收入
     */
    @Schema(description = "现时每月收入")
    private BigDecimal currentMonthlyIncome;

    /**
     * 公司电话区号
     */
    @Schema(description = "公司电话区号")
    private String companyMobileCode;

    /**
     * 公司电话
     */
    @Schema(description = "公司电话")
    private String companyMobile;

    /**
     * 固定电话区号
     */
    @Schema(description = "固定电话区号")
    private String landlineCode;

    /**
     * 固定电话
     */
    @Schema(description = "固定电话")
    private String landline;

    /**
     * 其他电话
     */
    @Schema(description = "其他电话")
    private String otherMobile;

    /**
     * 过往一年是否所属国家以外地区居住超过182日: 0-否, 1-是（字典）
     */
    @Schema(description = "过往一年是否所属国家以外地区居住超过182日: 0-否, 1-是（字典）")
    private Integer isExceed;

    /**
     * 是否拥有其他国家公民身份（如美国、日本等）: 0-否, 1-是（字典）
     */
    @Schema(description = "是否拥有其他国家公民身份（如美国、日本等）: 0-否, 1-是（字典）")
    private Integer isOtherCountry;

    /**
     * 是否接受推广信息: 0-否, 1-是（字典）
     */
    @Schema(description = "是否接受推广信息: 0-否, 1-是（字典）")
    private Integer isPromotion;

    /**
     * 投保人邮政编码
     */
    @Schema(description = "投保人邮政编码")
    private String postalCode;

    /**
     * 旅行（字典）
     */
    @Schema(description = "旅行（字典）")
    private String travel;

    /**
     * 运动（字典）
     */
    @Schema(description = "运动（字典）")
    private String exercise;

    /**
     * 游戏（字典）
     */
    @Schema(description = "游戏（字典）")
    private String game;

    /**
     * 电影/戏剧（字典）
     */
    @Schema(description = "电影/戏剧（字典）")
    private String movieDrama;

    /**
     * 美食（字典）
     */
    @Schema(description = "美食（字典）")
    private String delicacy;

    /**
     * 地址列表（json串）
     */
    @Schema(description = "地址列表（json串）")
    private String addressList;

    /**
     * 吸烟量(支/天)
     */
    @Schema(description = "吸烟量(支/天)")
    private String smokingVolume;

    /**
     * 货币（字典）
     */
    @Schema(description = "货币（字典）")
    private String currency;

    /**
     * 公司名称（英文）
     */
    @Schema(description = "公司名称（英文）")
    private String companyNameEn;

    /**
     * 公司商业登记号码
     */
    @Schema(description = "公司商业登记号码")
    private String companyBusinessNo;

    /**
     * 公司注册日期
     */
    @Schema(description = "公司注册日期")
    private Date companyRegisterTime;

    /**
     * 公司注册地区（字典）
     */
    @Schema(description = "公司注册地区（字典）")
    private String companyRegisterRegion;

    /**
     * 公司邮箱
     */
    @Schema(description = "公司邮箱")
    private String companyEmail;

    /**
     * 公司登记地址
     */
    @Schema(description = "公司登记地址")
    private String companyEnterAddress;

    /**
     * 授权代表姓名中文-名字
     */
    @Schema(description = "授权代表姓名中文-名字")
    private String authNameCn;

    /**
     * 授权代表姓名英文-名字
     */
    @Schema(description = "授权代表姓名英文-名字")
    private String authNameEn;

    /**
     * 授权代表职称
     */
    @Schema(description = "授权代表职称")
    private String authProfessional;

    /**
     * 授权代表电话区号
     */
    @Schema(description = "授权代表电话区号")
    private String authMobileCode;

    /**
     * 授权代表电话
     */
    @Schema(description = "授权代表电话")
    private String authMobile;

    /**
     * 备注
     */
    @Schema(description = "备注")
    private String remark;
}
