package com.yd.csf.service.dto;

import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;
import java.util.List;

/**
 * 新单跟进统一请求DTO - 用于新增和修改
 */
@Data
public class PolicyFollowDto implements Serializable {
    private static final long serialVersionUID = 1L;

    @Schema(description = "新单跟进唯一业务ID（修改时必填）")
    private String policyBizId;

    @Schema(description = "保单号")
    private String policyNo;

    @Schema(description = "预约信息主表唯一业务ID")
    private String appointmentBizId;

    @Schema(description = "预约编号")
    private String appointmentNo;

    @Schema(description = "客户业务id")
    private String customerBizId;

    @Schema(description = "递交日期", format = "yyyy-MM-dd")
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date submitDate;

    @Schema(description = "客户名称")
    private String customerName;

    @Schema(description = "签单日期", format = "yyyy-MM-dd")
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date signDate;

    @Schema(description = "签单人")
    private String signer;

    @Schema(description = "签单人业务id")
    private String signerBizId;

    @Schema(description = "签单人执业编号")
    private String signerRegNo;

    @Schema(description = "签单地点")
    private String signLocation;

    @Schema(description = "缮发日期", format = "yyyy-MM-dd")
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date issueDate;

    @Schema(description = "冷静期结束日期", format = "yyyy-MM-dd")
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date coolingOffEndDate;

    @Schema(description = "冷静期天数")
    private Integer coolingOffDays;

    @Schema(description = "核保日期", format = "yyyy-MM-dd")
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date underwritingDate;

    @Schema(description = "生效日期", format = "yyyy-MM-dd")
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date effectiveDate;

    @Schema(description = "续保日期", format = "yyyy-MM-dd")
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date renewalDate;

    @Schema(description = "保单回执日期", format = "yyyy-MM-dd")
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date receiptDate;

    @Schema(description = "回执状态")
    private String receiptStatus;

    @Schema(description = "是否开通直接支付: 0-否, 1-是")
    private Integer directPaymentEnabled;

    @Schema(description = "供款年期")
    private Integer issueNumber;

    @Schema(description = "保障期限")
    private Integer guaranteePeriod;

    @Schema(description = "保额（重疾险）")
    private BigDecimal sumInsured;

    @Schema(description = "付款频率（字典）")
    private String paymentFrequency;

    @Schema(description = "每期保费")
    private BigDecimal eachIssuePremium;

    @Schema(description = "是否预缴: 0-否, 1-是")
    private Integer isPrepay;

    @Schema(description = "是否追溯: 0-否, 1-是")
    private Integer isTraceable;

    @Schema(description = "回溯日期", format = "yyyy-MM-dd")
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date retroactiveDate;

    @Schema(description = "预缴年期")
    private Integer prepaidTerm;

    @Schema(description = "预付额")
    private String prepaidAmount;

    @Schema(description = "折扣后预付额")
    private String prepaidAmountAfterDiscount;

    @Schema(description = "保单截止日期", format = "yyyy-MM-dd")
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date policyExpirationDate;

    @Schema(description = "缴费编号")
    private String paymentNumber;

    @Schema(description = "产品上架信息表唯一业务ID")
    private String productLaunchBizId;

    @Schema(description = "产品名称")
    private String productName;

    @Schema(description = "产品类别")
    private String productCate;

    @Schema(description = "保险公司")
    private String insuranceCompany;

    @Schema(description = "保险公司业务id")
    private String insuranceCompanyBizId;

    @Schema(description = "对账公司")
    private String reconciliationCompany;

    @Schema(description = "对账公司业务id")
    private String reconciliationCompanyBizId;

    @Schema(description = "新单跟进状态")
    private String status;

    @Schema(description = "下一步跟进状态列表")
    private String nextStatusList;

    @Schema(description = "保單持有人")
    private String policyHolder;

    @Schema(description = "受保人")
    private String insured;

    @Schema(description = "受保人年龄")
    private Integer insuredAge;

    @Schema(description = "宽限期")
    private Integer gracePeriod;

    @Schema(description = "是否参加递增保障权益: 0-否, 1-是（字典）")
    private Integer isJoin;

    @Schema(description = "保单币种")
    private String policyCurrency;

    @Schema(description = "首期付款方式（字典）")
    private String initialPaymentMethod;

    @Schema(description = "首期保费（不含徽费，预缴保费）")
    private BigDecimal initialPremium;

    @Schema(description = "寄送方式（字典）: 1-自提 2-快递")
    private String mailingMethod;

    @Schema(description = "续期付款方式（字典）")
    private String renewalPaymentMethod;

    @Schema(description = "红利付款方式（字典）")
    private String dividendPaymentMethod;

    @Schema(description = "快递单号")
    private String deliveryNo;

    @Schema(description = "保单征费")
    private String policyLevy;

    @Schema(description = "首期保费已付")
    private String initialPremiumPaid;

    @Schema(description = "首期保费应付")
    private String initialPremiumDue;

    @Schema(description = "最近付款日期", format = "yyyy-MM-dd")
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date latestPaymentDate;

    @Schema(description = "经纪公司签收日期", format = "yyyy-MM-dd")
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date brokerSignDate;

    @Schema(description = "保险公司寄出日期", format = "yyyy-MM-dd")
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date insurerMailingDate;

    @Schema(description = "客户签收日期", format = "yyyy-MM-dd")
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date customerSignDate;

    @Schema(description = "转介人列表")
    private List<PolicyBrokerDto> brokerList;
}
