package com.yd.csf.service.dto;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.yd.common.dto.PageDto;
import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.io.Serializable;
import java.time.LocalDate;
import java.util.List;

/**
 * 查询customer请求
 */
@EqualsAndHashCode(callSuper = true)
@Data
public class PolicyFollowQueryRequest extends PageDto implements Serializable {

    /**
     * 保单号
     */
    @Schema(description = "保单号")
    private String policyNo;

    /**
     * 新单状态
     */
    @Schema(description = "新单状态 'CHECKING'-'审核中','UNDERWRITING'-'承保中','FINISHED'-'已完成','DECLINED'-'已拒绝','CANCELLED'-'已取消', 字典值: csf_policy_follow_status")
    private String status;

    /**
     * 预约编号
     */
    @Schema(description = "预约编号")
    private String appointmentNo;

    /**
     * 签单日开始
     */
    @Schema(description = "签单日期开始 格式: yyyy-MM-dd", example = "2023-01-01", format = "yyyy-MM-dd")
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private LocalDate signDateStart;

    /**
     * 签单日结束
     */
    @Schema(description = "签单日期结束 格式: yyyy-MM-dd", example = "2023-01-01", format = "yyyy-MM-dd")
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private LocalDate signDateEnd;

    /**
     * 最晚缴费日期
     */
    @Schema(description = "最晚缴费日期 格式: yyyy-MM-dd", example = "2023-01-01", format = "yyyy-MM-dd")
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private LocalDate latestPaymentDate;

    /**
     * 投保人业务id列表
     */
    @Schema(description = "投保人业务id列表")
    private List<String> policyholderBizIdList;

    /**
     * 受保人业务id列表
     */
    @Schema(description = "受保人业务id列表")
    private List<String> policyInsurantBizIdList;

    /**
     * 保险公司业务id列表
     */
    @Schema(description = "保险公司业务id列表")
    private List<String> insuranceCompanyBizIdList;

    /**
     * 产品计划业务id列表
     */
    @Schema(description = "产品计划业务id列表")
    private List<String> productLaunchBizIdList;

    /**
     * 缴费年期
     */
    @Schema(description = "缴费年期")
    private String paymentTerm;

    private static final long serialVersionUID = 1L;
}