package com.yd.csf.service.model;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import java.io.Serializable;
import java.time.LocalDateTime;
import lombok.Getter;
import lombok.Setter;

/**
 * <p>
 * 推荐关系表
 * </p>
 *
 * @author zxm
 * @since 2025-10-15
 */
@Getter
@Setter
@TableName("agent_referral_relation")
public class AgentReferralRelation implements Serializable {

    private static final long serialVersionUID = 1L;

    /**
     * 主键ID
     */
    @TableId(value = "id", type = IdType.AUTO)
    private Long id;

    /**
     * 推荐关系表唯一业务ID
     */
    @TableField("referral_biz_id")
    private String referralBizId;

    /**
     * 被推荐人ID（客户端用户表唯一业务ID）
     */
    @TableField("agent_id")
    private String agentId;

    /**
     * 推荐人ID（客户端用户表唯一业务ID，如果是PC，这里就是sys_user的用户ID）
     */
    @TableField("referrer_id")
    private String referrerId;

    /**
     * 推荐人账号（客户端用户表手机号，如果是PC，这里就是sys_user的用户名）
     */
    @TableField("referrer_account")
    private String referrerAccount;

    /**
     * 推荐路径(用于快速查询关系链)
     */
    @TableField("referral_path")
    private String referralPath;

    /**
     * 是否有效(0:否 1:是)
     */
    @TableField("is_active")
    private Integer isActive;

    /**
     * 推荐来源（PC、小程序等，字典，PC就是中台加入申请的）
     */
    @TableField("source")
    private String source;

    /**
     * 所属租户唯一业务ID（冗余）
     */
    @TableField("tenant_biz_id")
    private String tenantBizId;

    /**
     * 所属项目唯一业务ID（冗余）
     */
    @TableField("project_biz_id")
    private String projectBizId;

    /**
     * 通用备注
     */
    @TableField("remark")
    private String remark;

    /**
     * 删除标识: 0-正常, 1-删除
     */
    @TableField("is_deleted")
    private Integer isDeleted;

    /**
     * 创建人ID
     */
    @TableField("creator_id")
    private String creatorId;

    /**
     * 更新人ID
     */
    @TableField("updater_id")
    private String updaterId;

    /**
     * 创建时间
     */
    @TableField("create_time")
    private LocalDateTime createTime;

    /**
     * 更新时间
     */
    @TableField("update_time")
    private LocalDateTime updateTime;
}
