package com.yd.csf.service.dto;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;
import java.util.List;

@Data
@Builder
@NoArgsConstructor
@AllArgsConstructor
public class FormulaConfigDto {

    /**
     * 公式配置表唯一业务ID
     */
    private String formulaBizId;

    /**
     * 公式配置表唯一业务ID集合
     */
    private List<String> formulaBizIdList;

    /**
     * 公式名称
     */
    private String name;

    /**
     * 查询是否排除当前
     */
    @Builder.Default
    private Boolean isExcludeMy = false;
}
