package com.yd.csf.service.vo;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.yd.csf.service.model.Policy;
import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Data;
import org.springframework.beans.BeanUtils;

import java.math.BigDecimal;
import java.util.Date;

@Data
public class PolicyVO {
    /**
     * 保单业务ID
     */
    @Schema(description = "保单业务ID")
    private String policyBizId;

    /**
     * 保单号
     */
    @Schema(description = "保单号")
    private String policyNo;

    /**
     * 用户业务id
     */
    @Schema(description = "用户业务id")
    private String userBizId;

    /**
     * 产品代码
     */
    @Schema(description = "产品代码")
    private String productCode;

    /**
     * 产品名称
     */
    @Schema(description = "产品名称")
    private String productName;

    /**
     * 产品计划业务id
     */
    @Schema(description = "产品计划业务id")
    private String productLaunchBizId;

    /**
     * 产品类别
     */
    @Schema(description = "产品类别")
    private String productCate;

    /**
     * 保险公司
     */
    @Schema(description = "保险公司")
    private String insuranceCompany;

    /**
     * 保险公司业务id
     */
    @Schema(description = "保险公司业务id")
    private String insuranceCompanyBizId;

    /**
     * 保單持有人
     */
    @Schema(description = "保單持有人")
    private String policyHolder;

    /**
     * 受保人
     */
    @Schema(description = "受保人")
    private String insured;

    /**
     * 供款年期
     */
    @Schema(description = "供款年期")
    private Integer paymentTerm;

    /**
     * 期交保费
     */
    @Schema(description = "期交保费")
    private BigDecimal paymentPremium;

    /**
     * 每期保费
     */
    @Schema(description = "每期保费")
    private BigDecimal eachIssuePremium;

    /**
     * 保单状态
     */
    @Schema(description = "保单状态 生效中，保单失效，期满终止，已转出，退保，被拒保，取消申请 字典值：csf_policy_status")
    private String status;

    /**
     * 保单币种
     */
    @Schema(description = "保单币种")
    private String currency;

    /**
     * 首期保费（不含徽费，预缴保费）
     */
    @Schema(description = "首期保费（不含徽费，预缴保费）")
    private Integer initialPremium;

    /**
     * 签单日期
     */
    @Schema(description = "签单日期")
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date signDate;

    /**
     * 缮发日期
     */
    @Schema(description = "缮发日期")
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date issueDate;

    /**
     * 生效日期
     */
    @Schema(description = "生效日期")
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date effectiveDate;

    /**
     * 续保日期
     */
    @Schema(description = "续保日期")
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date renewalDate;

    /**
     * 是否预缴: 0-否, 1-是
     */
    @Schema(description = "是否预缴: 0-否, 1-是")
    private Integer isPrepaid;

    /**
     * 是否预缴: 0-否, 1-是
     */
    @Schema(description = "是否预缴: 0-否, 1-是")
    private Integer isPrepay;

    /**
     * 预缴年期
     */
    @Schema(description = "预缴年期")
    private Integer prepaidTerm;

    /**
     * 对账公司
     */
    @Schema(description = "对账公司")
    private String reconciliationCompany;

    /**
     * 对账公司业务id
     */
    @Schema(description = "对账公司业务id")
    private String reconciliationCompanyBizId;

    /**
     * 通用备注
     */
    @Schema(description = "通用备注")
    private String remark;


    /**
     * 对象转包装类
     *
     * @param policy
     * @return
     */
    public static PolicyVO objToVo(Policy policy) {
        if (policy == null) {
            return null;
        }
        PolicyVO policyVO = new PolicyVO();
        BeanUtils.copyProperties(policy, policyVO);
        policyVO.setEachIssuePremium(policy.getPaymentPremium());
        policyVO.setIsPrepay(policy.getIsPrepaid());

        return policyVO;
    }
}
