package com.yd.csf.service.model;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;

import com.yd.csf.service.vo.FnaVO;
import lombok.Data;
import org.springframework.beans.BeanUtils;

/**
 * 预计来佣表
 * @TableName commission_expected
 */
@TableName(value ="commission_expected")
@Data
public class CommissionExpected implements Serializable {
    /**
     * serial id
     */
    @TableId(type = IdType.AUTO)
    private Long id;

    /**
     * 保单来佣业务id
     */
    private String commissionBizId;

    /**
     * 保单号
     */
    private String policyNo;

    /**
     * 对账公司
     */
    private String reconciliationCompany;

    /**
     * 对账公司业务id
     */
    private String reconciliationCompanyBizId;

    /**
     * 佣金期数(1=第一年; 2=第二年; 3=第三年; 4=第四年; 5=第五年)
     */
    private Integer commissionPeriod;

    /**
     * 总来佣期数
     */
    private Integer totalPeriod;

    /**
     * 来佣名称(1:销售拥金;2:销售奖金;3:销售津贴;4:续期佣金;5:服务津贴;等等)
     */
    private String commissionName;

    /**
     * 来佣类型(1:销售拥金;2:销售奖金;3:销售津贴;4:续期佣金;5:服务津贴;等等)
     */
    private String commissionType;

    /**
     * 来佣金额
     */
    private BigDecimal amount;

    /**
     * 来佣币种
     */
    private String currency;

    /**
     * 来佣日期
     */
    private Date commissionDate;

    /**
     * 来佣状态 0=待来佣 1=已来佣 2=部分来佣
     */
    private String status;

    /**
     * 通用备注
     */
    private String remark;

    /**
     * 删除标识: 0-正常, 1-删除
     */
    private Integer isDeleted;

    /**
     * 创建人ID
     */
    private String creatorId;

    /**
     * 更新人ID
     */
    private String updaterId;

    /**
     * 创建时间
     */
    private Date createTime;

    /**
     * 更新时间
     */
    private Date updateTime;

    @TableField(exist = false)
    private static final long serialVersionUID = 1L;
}