package com.yd.csf.service.dto;

import com.yd.common.dto.PageDto;
import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.io.Serializable;
import java.util.List;

/**
 * 查询fna请求
 *
 */
@EqualsAndHashCode(callSuper = true)
@Data
public class FnaQueryRequest extends PageDto implements Serializable {

    /**
     * 客户姓名
     */
    @Schema(description = "客户姓名")
    private String customerName;

    /**
     * 预约编号
     */
    @Schema(description = "预约编号")
    private String appointmentNo;

    /**
     * 新单编号
     */
    @Schema(description = "新单编号")
    private String policyId;

    /**
     * 保单号
     */
    @Schema(description = "保单号")
    private String policyNo;


    private static final long serialVersionUID = 1L;
}