package com.yd.csf.service.enums;

/**
 * 预计来佣状态枚举
 */
public enum CommissionExpectedStatusEnum {

    PENDING("待来佣","0"),
    COMPARED("已来佣","1"),
    PARTIAL("部分来佣","2"),

    ;
    //字典项标签（名称）
    private String itemLabel;
    //字典项值
    private String itemValue;

    //构造函数
    CommissionExpectedStatusEnum(String itemLabel, String itemValue) {
        this.itemLabel = itemLabel;
        this.itemValue = itemValue;
    }

    public String getItemLabel() {
        return itemLabel;
    }

    public String getItemValue() {
        return itemValue;
    }
}
