package com.yd.csf.service.model;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import java.io.Serializable;
import java.util.Date;
import lombok.Data;

/**
 * 保单转介人表
 * @TableName policy_broker
 */
@TableName(value ="policy_broker")
@Data
public class PolicyBroker implements Serializable {
    /**
     * id
     */
    @TableId(type = IdType.AUTO)
    private Long id;

    /**
     * 新单跟进唯一业务ID
     */
    private String policyBizId;

    /**
     * 保单号
     */
    private String policyNo;

    /**
     * 转介人名称
     */
    private String brokerName;

    /**
     * 转介人业务ID
     */
    private String brokerBizId;

    /**
     * 所属团队
     */
    private String team;

    /**
     * 所属团队业务id
     */
    private String teamBizId;

    /**
     * 通用备注
     */
    private String remark;

    /**
     * 删除标识: 0-正常, 1-删除
     */
    private Integer isDeleted;

    /**
     * 创建人ID
     */
    private String creatorId;

    /**
     * 更新人ID
     */
    private String updaterId;

    /**
     * 创建时间
     */
    private Date createTime;

    /**
     * 更新时间
     */
    private Date updateTime;

    @TableField(exist = false)
    private static final long serialVersionUID = 1L;
}