package com.yd.csf.service.model;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import lombok.Getter;
import lombok.Setter;

import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDateTime;

/**
 * <p>
 * 投保人信息表
 * </p>
 *
 * @author zxm
 * @since 2025-09-02
 */
@Getter
@Setter
@TableName("policyholder")
public class Policyholder implements Serializable {

    private static final long serialVersionUID = 1L;

    @TableId(value = "id", type = IdType.AUTO)
    private Long id;

    /**
     * 预约信息主表唯一业务ID
     */
    @TableField("appointment_biz_id")
    private String appointmentBizId;

    /**
     * 投保人信息表唯一业务ID
     */
    @TableField("policyholder_biz_id")
    private String policyholderBizId;

    /**
     * 客户类型（字典）
     */
    @TableField("customer_type")
    private String customerType;

    /**
     * 关联客户信息表唯一业务ID（冗余字段）
     */
    @TableField("customer_biz_id")
    private String customerBizId;

    /**
     * 关联客户编号（和客户信息表唯一业务ID是一对，唯一，冗余字段）
     */
    @TableField("customer_no")
    private String customerNo;

    /**
     * 名字
     */
    @TableField("name")
    private String name;

    /**
     * 名字-英文
     */
    @TableField("name_en")
    private String nameEn;

    /**
     * 性别（字典）
     */
    @TableField("gender")
    private String gender;

    /**
     * 证件类型（字典）
     */
    @TableField("document_type")
    private String documentType;

    /**
     * 证件号码
     */
    @TableField("id_number")
    private String idNumber;

    /**
     * 出生日期
     */
    @TableField("birthday")
    private LocalDateTime birthday;

    /**
     * 年龄
     */
    @TableField("age")
    private String age;

    /**
     * 居住地址
     */
    @TableField("residential_address")
    private String residentialAddress;

    /**
     * 通讯地址
     */
    @TableField("mailing_address")
    private String mailingAddress;

    /**
     * 移动电话区号
     */
    @TableField("mobile_code")
    private String mobileCode;

    /**
     * 移动电话
     */
    @TableField("mobile")
    private String mobile;

    /**
     * 邮箱
     */
    @TableField("email")
    private String email;

    /**
     * 公司名称
     */
    @TableField("company_name")
    private String companyName;

    /**
     * 公司地址
     */
    @TableField("company_address")
    private String companyAddress;

    /**
     * 行业
     */
    @TableField("industry")
    private String industry;

    /**
     * 职位
     */
    @TableField("position")
    private String position;

    /**
     * 风险偏好（字典）
     */
    @TableField("risk_appetite")
    private String riskAppetite;

    /**
     * 是否VIP: 0-否, 1-是（字典）
     */
    @TableField("is_vip")
    private Integer isVip;

    /**
     * vip备注
     */
    @TableField("vip_remark")
    private String vipRemark;

    /**
     * 称谓（字典）
     */
    @TableField("appellation")
    private String appellation;

    /**
     * 是否区分吸烟（字典）
     */
    @TableField("smoking_allowed")
    private String smokingAllowed;

    /**
     * 出生地（省市）
     */
    @TableField("birthplace")
    private String birthplace;

    /**
     * 国籍
     */
    @TableField("nationality")
    private String nationality;

    /**
     * 护照号码
     */
    @TableField("passport_no")
    private String passportNo;

    /**
     * 通行证号码
     */
    @TableField("pass_no")
    private String passNo;

    /**
     * 身高
     */
    @TableField("height")
    private String height;

    /**
     * 体重
     */
    @TableField("weight")
    private String weight;

    /**
     * BMI
     */
    @TableField("bmi")
    private String bmi;

    /**
     * 平均每月支出
     */
    @TableField("month_expenditure")
    private BigDecimal monthExpenditure;

    /**
     * 平均每月收入
     */
    @TableField("month_income")
    private BigDecimal monthIncome;

    /**
     * 受雇于现职年期
     */
    @TableField("current_tenure")
    private BigDecimal currentTenure;

    /**
     * 总流动资产
     */
    @TableField("total_current_assets")
    private BigDecimal totalCurrentAssets;

    /**
     * 总负债额
     */
    @TableField("total_debt")
    private BigDecimal totalDebt;

    /**
     * 受供养人数目
     */
    @TableField("dependents_num")
    private Integer dependentsNum;

    /**
     * 婚姻状况（字典）
     */
    @TableField("marital_status")
    private String maritalStatus;

    /**
     * 教育程度（字典）
     */
    @TableField("education_level")
    private String educationLevel;

    /**
     * 总工作年期
     */
    @TableField("total_working_years")
    private BigDecimal totalWorkingYears;

    /**
     * 现时每月收入
     */
    @TableField("current_monthly_income")
    private BigDecimal currentMonthlyIncome;

    /**
     * 公司电话区号
     */
    @TableField("company_mobile_code")
    private String companyMobileCode;

    /**
     * 公司电话
     */
    @TableField("company_mobile")
    private String companyMobile;

    /**
     * 固定电话区号
     */
    @TableField("landline_code")
    private String landlineCode;

    /**
     * 固定电话
     */
    @TableField("landline")
    private String landline;

    /**
     * 其他电话
     */
    @TableField("other_mobile")
    private String otherMobile;

    /**
     * 过往一年是否所属国家以外地区居住超过182日: 0-否, 1-是（字典）
     */
    @TableField("is_exceed")
    private Integer isExceed;

    /**
     * 是否拥有其他国家公民身份（如美国、日本等）: 0-否, 1-是（字典）
     */
    @TableField("is_other_country")
    private Integer isOtherCountry;

    /**
     * 是否接受推广信息: 0-否, 1-是（字典）
     */
    @TableField("is_promotion")
    private Integer isPromotion;

    /**
     * 投保人邮政编码
     */
    @TableField("postal_code")
    private String postalCode;

    /**
     * 旅行（字典）
     */
    @TableField("travel")
    private String travel;

    /**
     * 运动（字典）
     */
    @TableField("exercise")
    private String exercise;

    /**
     * 游戏（字典）
     */
    @TableField("game")
    private String game;

    /**
     * 电影/戏剧（字典）
     */
    @TableField("movie_drama")
    private String movieDrama;

    /**
     * 美食（字典）
     */
    @TableField("delicacy")
    private String delicacy;

    /**
     * 通用备注
     */
    @TableField("remark")
    private String remark;

    /**
     * 删除标识: 0-正常, 1-删除
     */
    @TableField("is_deleted")
    private Integer isDeleted;

    /**
     * 创建人ID
     */
    @TableField("creator_id")
    private String creatorId;

    /**
     * 更新人ID
     */
    @TableField("updater_id")
    private String updaterId;

    /**
     * 创建时间
     */
    @TableField("create_time")
    private LocalDateTime createTime;

    /**
     * 更新时间
     */
    @TableField("update_time")
    private LocalDateTime updateTime;
}
