package com.yd.csf.service.service;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.yd.csf.service.dto.*;
import com.yd.csf.service.model.Commission;
import com.baomidou.mybatisplus.extension.service.IService;
import com.yd.csf.service.model.CommissionExpected;
import com.yd.csf.service.vo.CommissionStatisticsVO;
import com.yd.csf.service.vo.CommissionVO;

import java.util.List;
import java.util.Map;

/**
* @author Zhang Jianan
* @description 针对表【commission(保单来佣表)】的数据库操作Service
* @createDate 2025-09-19 16:08:05
*/
public interface CommissionService extends IService<Commission> {

    QueryWrapper<Commission> getQueryWrapper(CommissionQueryRequest commissionQueryRequest);

    Page<CommissionVO> getCommissionVOPage(Page<Commission> commissionPage);

    Boolean updateCommission(CommissionUpdateRequest commissionUpdateRequest);

    Boolean generateFortune(GenerateFortuneRequest generateFortuneRequest);

    Boolean addCommission(CommissionAddRequest commissionAddRequest);

    Commission getByCommissionBizId(String commissionBizId);

    void compareWithExpected(String premium, Commission commission, CommissionExpected expected);

    List<Commission> queryList(CommissionDto dto);

    List<CommissionBindPolicyBrokerDto> queryCommissionBindPolicyBrokerList(CommissionDto dto);

    CommissionStatisticsVO getCommissionStatistics(List<Long> commissionIds);
}
