package com.yd.csf.service.vo;

import com.yd.csf.service.dto.*;
import com.yd.csf.service.model.FnaForm;
import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Data;
import org.springframework.beans.BeanUtils;

import java.io.Serializable;
import java.util.List;

/**
 * Fna表单视图
 */
@Data
public class FnaFormVO implements Serializable {

    /**
     * id
     */
    private Long id;

    /**
     * fnaForm 业务ID
     */
    @Schema(description = "fnaForm 业务ID")
    private String fnaFormBizId;

    /**
     * 客户唯一业务ID
     */
    @Schema(description = "客户唯一业务ID")
    private String customerBizId;

    /**
     * 介绍人列表
     */
    @Schema(description = "介绍人列表")
    private List<BrokerData> brokerList;

    /**
     * 受供养人列表
     */
    @Schema(description = "受供养人列表")
    private List<DependantData> dependantList;

    /**
     * 保单持有人个人已有保障
     */
    @Schema(description = "保单持有人个人已有保障")
    private List<ExistingSecurity> existingSecurityOwner;

    /**
     * 不动产信息
     */
    @Schema(description = "不动产信息")
    private List<OwnerProperties> primaryResidence;

    /**
     * 保费负担能力评估
     */
    @Schema(description = "保费负担能力评估")
    private PremiumAffordability premiumAffordability;

    /**
     * 公司业务资料
     */
    @Schema(description = "公司业务资料")
    private CompanyBusinessData companyBusinessData;

    /**
     * 封装类转对象
     *
     * @param fnaFormVO
     * @return
     */
    public static FnaForm voToObj(FnaFormVO fnaFormVO) {
        if (fnaFormVO == null) {
            return null;
        }
        FnaForm fnaForm = new FnaForm();
        BeanUtils.copyProperties(fnaFormVO, fnaForm);

        return fnaForm;
    }

    /**
     * 对象转封装类
     *
     * @param fnaForm
     * @return
     */
    public static FnaFormVO objToVo(FnaForm fnaForm) {
        if (fnaForm == null) {
            return null;
        }
        FnaFormVO fnaFormVO = new FnaFormVO();
        BeanUtils.copyProperties(fnaForm, fnaFormVO);

        return fnaFormVO;
    }
}
