package com.yd.csf.service.dto;

import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;

@Data
public class FortuneAccountUpdateRequest implements Serializable {

    /**
     * 出账数据业务ID
     */
    @Schema(description = "出账数据业务ID", requiredMode = Schema.RequiredMode.REQUIRED)
    private String fortuneAccountBizId;

     /**
      * 经纪人
      */
    @Schema(description = "经纪人")
    private String broker;

    /**
     * 团队
     */
    @Schema(description = "团队")
    private String team;

    /**
     * 币种
     */
    @Schema(description = "币种")
    private String currency;

    /**
     * 金额
     */
    @Schema(description = "金额")
    private BigDecimal amount;

    /**
     * 出账日期
     */
    @Schema(description = "出账日期")
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date fortuneAccountDate;

    /**
     * 备注
     */
    @Schema(description = "备注")
    private String remark;

    private static final long serialVersionUID = 1L;
}
