package com.yd.csf.service.dto;

import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Data;

import java.util.List;

@Data
public class ChangePolicyFollowStatusRequest {

    /**
     * 新单编号
     */
    @Schema(description = "新单编号", requiredMode = Schema.RequiredMode.REQUIRED)
    private String policyBizId;

    /**
     * 新单状态
     */
    @Schema(description = "新单状态 'CHECKING'-'文件检查中','UNDERWRITING'-'承保中','FINISHED'-'已完成','DECLINED'-'已拒绝','CANCELLED'-'已取消','FOLLOW_UP'-'待跟进', 字典值: policy_follow_status")
    private String status;

    /**
     * 跟进信息
     */
    @Schema(description = "跟进信息")
    private String message;

    /**
     * 附件列表
     */
    @Schema(description = "附件列表")
    private List<String> attachments;
}
