package com.yd.csf.service.model;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import java.io.Serializable;
import java.time.LocalDateTime;
import lombok.Getter;
import lombok.Setter;

/**
 * <p>
 * 预约附件信息表
 * </p>
 *
 * @author zxm
 * @since 2025-09-01
 */
@Getter
@Setter
@TableName("appointment_file")
public class AppointmentFile implements Serializable {

    private static final long serialVersionUID = 1L;

    @TableId(value = "id", type = IdType.AUTO)
    private Long id;

    /**
     * 预约信息主表唯一业务ID
     */
    @TableField("appointment_biz_id")
    private String appointmentBizId;

    /**
     * 中台文件元数据表唯一业务ID
     */
    @TableField("oss_file_biz_id")
    private String ossFileBizId;

    /**
     * 预约附件信息表唯一业务ID
     */
    @TableField("appointment_file_biz_id")
    private String appointmentFileBizId;

    /**
     * 文件名
     */
    @TableField("file_name")
    private String fileName;

    /**
     * 文件访问路径
     */
    @TableField("file_url")
    private String fileUrl;

    /**
     * 通用备注
     */
    @TableField("remark")
    private String remark;

    /**
     * 删除标识: 0-正常, 1-删除
     */
    @TableField("is_deleted")
    private Integer isDeleted;

    /**
     * 创建人ID
     */
    @TableField("creator_id")
    private String creatorId;

    /**
     * 更新人ID
     */
    @TableField("updater_id")
    private String updaterId;

    /**
     * 创建时间
     */
    @TableField("create_time")
    private LocalDateTime createTime;

    /**
     * 更新时间
     */
    @TableField("update_time")
    private LocalDateTime updateTime;
}
