package com.yd.csf.service.dto;

import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Data;

import java.io.Serializable;
import java.util.List;

/**
 * 更新Fna表单请求
 *
 */
@Data
public class FnaFormUpdateRequest implements Serializable {
    /**
     * 保存方式 temp-暂存 save-保存
     */
    @Schema(description = "保存方式 temp-暂存 save-保存", requiredMode = Schema.RequiredMode.REQUIRED)
    private String saveType;

    /**
     * Fna表单唯一业务ID
     */
    @Schema(description = "Fna表单唯一业务ID", requiredMode = Schema.RequiredMode.REQUIRED)
    private String fnaFormBizId;

    /**
     * 客户唯一业务ID
     */
    @Schema(description = "客户唯一业务ID")
    private String customerBizId;

    /**
     * 个人资料
     */
    @Schema(description = "个人资料")
    private PersonalData personalData;

     /**
     * 税务国家列表
     */
    @Schema(description = "税务国家列表", requiredMode = Schema.RequiredMode.REQUIRED)
    private List<TaxCountry> taxList;

    /**
     * 家庭状况
     */
    @Schema(description = "家庭状况（父亲-father/母亲-mother/配偶-spouse/子女-children）")
    private List<FamilyMember> familyMembers;

    /**
     * 保单持有人个人已有保障
     */
    private List<ExistingSecurity> existingSecurityOwner;

    /**
     * 受保人个人已有保障
     */
    private List<ExistingSecurity> existingSecurityInsured;

    /**
     * 收支情况
     */
    @Schema(description = "收支情况")
    private IncomeExpense incomeExpense;

    /**
     * 流动资产
     */
    @Schema(description = "流动资产")
    private LiquidAssets liquidAssets;

    /**
     * 自住用途之房地產
     */
    @Schema(description = "自住用途之房地產")
    private List<OwnerProperties> primaryResidence;

    /**
     * 投資房地產
     */
    @Schema(description = "投資房地產")
    private List<InvestmentProperties> investment;

    /**
     * 公司业务资料
     */
    @Schema(description = "公司业务资料")
    private CompanyBusinessData companyBusinessData;

    /**
     * 其他问题
     */
    @Schema(description = "Fna表单其他问题")
    private FnaFormOther other;

    private static final long serialVersionUID = 1L;
}