package com.yd.csf.service.model;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDateTime;
import lombok.Getter;
import lombok.Setter;

/**
 * <p>
 * 保单发佣批次表 - 存储发佣批次信息，用于批量处理佣金计算和发放
 * </p>
 *
 * @author zxm
 * @since 2025-10-15
 */
@Getter
@Setter
@TableName("payout_batch")
public class PayoutBatch implements Serializable {

    private static final long serialVersionUID = 1L;

    /**
     * 主键ID
     */
    @TableId(value = "id", type = IdType.AUTO)
    private Long id;

    /**
     * 发佣批次表唯一业务ID
     */
    @TableField("batch_biz_id")
    private String batchBizId;

    /**
     * 批次号
     */
    @TableField("batch_no")
    private String batchNo;

    /**
     * 批次名称
     */
    @TableField("batch_name")
    private String batchName;

    /**
     * 发佣日期
     */
    @TableField("payout_date")
    private LocalDateTime payoutDate;

    /**
     * 总保费，该批次所有保单的总保费
     */
    @TableField("total_premium")
    private BigDecimal totalPremium;

    /**
     * 总佣金，该批次计算出的总佣金金额
     */
    @TableField("total_commission")
    private BigDecimal totalCommission;

    /**
     * 保单数量，该批次包含的保单总数
     */
    @TableField("policy_count")
    private Integer policyCount;

    /**
     * 批次状态：DRAFT-草稿, CALCULATING-计算中, CALCULATED-已计算, CONFIRMED-已确认, PAID-已发放
     */
    @TableField("batch_status")
    private String batchStatus;

    /**
     * 计算开始时间，记录批次佣金计算开始的时间
     */
    @TableField("calc_start_time")
    private LocalDateTime calcStartTime;

    /**
     * 计算结束时间，记录批次佣金计算结束的时间
     */
    @TableField("calc_end_time")
    private LocalDateTime calcEndTime;

    /**
     * 所属租户唯一业务ID（冗余）
     */
    @TableField("tenant_biz_id")
    private String tenantBizId;

    /**
     * 所属项目唯一业务ID（冗余）
     */
    @TableField("project_biz_id")
    private String projectBizId;

    /**
     * 通用备注
     */
    @TableField("remark")
    private String remark;

    /**
     * 删除标识: 0-正常, 1-删除
     */
    @TableField("is_deleted")
    private Integer isDeleted;

    /**
     * 创建人ID
     */
    @TableField("creator_id")
    private String creatorId;

    /**
     * 更新人ID
     */
    @TableField("updater_id")
    private String updaterId;

    /**
     * 创建时间
     */
    @TableField("create_time")
    private LocalDateTime createTime;

    /**
     * 更新时间
     */
    @TableField("update_time")
    private LocalDateTime updateTime;
}
