package com.yd.csf.service.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.yd.csf.feign.request.additional.ApiAdditionalPageRequest;
import com.yd.csf.feign.response.additional.ApiAdditionalPageResponse;
import com.yd.csf.service.dto.AdditionalDto;
import com.yd.csf.service.model.Additional;
import com.yd.csf.service.dao.AdditionalMapper;
import com.yd.csf.service.service.IAdditionalService;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.yd.user.service.model.SysProject;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

import java.util.List;
import java.util.Objects;

/**
 * <p>
 * 产品计划-附加险信息表 服务实现类
 * </p>
 *
 * @author zxm
 * @since 2025-09-01
 */
@Service
public class AdditionalServiceImpl extends ServiceImpl<AdditionalMapper, Additional> implements IAdditionalService {

    /**
     * 附加险分页查询
     * @param request
     * @return
     */
    @Override
    public IPage<ApiAdditionalPageResponse> page(Page<ApiAdditionalPageResponse> page,
                                                 ApiAdditionalPageRequest request) {

        return baseMapper.page(page,request);
    }

    /**
     * 查询列表
     * @param dto
     * @return
     */
    @Override
    public List<Additional> queryList(AdditionalDto dto) {
        List<Additional> list = baseMapper.selectList(new LambdaQueryWrapper<Additional>()
                .eq(StringUtils.isNotBlank(dto.getPlanBizId()),Additional::getPlanBizId,dto.getPlanBizId())
                .in(!CollectionUtils.isEmpty(dto.getAdditionalBizIdList()),Additional::getAdditionalBizId,dto.getAdditionalBizIdList())
        );
        return list;
    }

    /**
     * 查询单个对象
     * @param additionalBizId
     * @return
     */
    @Override
    public Additional queryOne(String additionalBizId) {
        return this.getOne(new LambdaQueryWrapper<Additional>().eq(Additional::getAdditionalBizId,additionalBizId));
    }

}
