package com.yd.email.feign.client;

import com.yd.common.result.Result;
import com.yd.email.feign.fallback.ApiEmailVariableGroupFeignFallbackFactory;
import com.yd.email.feign.request.ApiEmailVariableGroupAddRequest;
import com.yd.email.feign.request.ApiEmailVariableGroupEditRequest;
import com.yd.email.feign.request.ApiEmailVariableGroupPageRequest;
import com.yd.email.feign.response.ApiEmailVariableGroupDetailResponse;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.*;

/**
 * 邮箱服务-变量分组信息Feign客户端
 */
@FeignClient(name = "yd-email-api", fallbackFactory = ApiEmailVariableGroupFeignFallbackFactory.class)
public interface ApiEmailVariableGroupFeignClient {

    /**
     * 分页查询-变量分组
     * @param request
     * @return
     */
    @PostMapping("/page")
    Result page(@RequestBody ApiEmailVariableGroupPageRequest request);

    /**
     * 添加-变量分组
     * @param request
     * @return
     */
    @PostMapping("/add")
    Result add(@Validated @RequestBody ApiEmailVariableGroupAddRequest request);

    /**
     * 编辑-变量分组
     * @param request
     * @return
     */
    @PutMapping("/edit")
    Result edit(@Validated @RequestBody ApiEmailVariableGroupEditRequest request);

    /**
     * 详情-变量分组
     * @param variableGroupBizId 变量分组唯一业务ID
     * @return
     */
    @GetMapping("/detail")
    Result<ApiEmailVariableGroupDetailResponse> detail(@RequestParam(value = "variableGroupBizId") String variableGroupBizId);

    /**
     * 删除-变量分组
     * @param variableGroupBizId 变量分组唯一业务ID
     * @return
     */
    @DeleteMapping("/del")
    Result del(@RequestParam(value = "variableGroupBizId") String variableGroupBizId);
    
}
