package com.yd.email.api.controller;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.yd.common.result.Result;
import com.yd.email.api.service.ApiEmailProviderConfigService;
import com.yd.email.feign.client.ApiEmailProviderConfigFeignClient;
import com.yd.email.feign.request.ApiEmailProviderConfigAddRequest;
import com.yd.email.feign.request.ApiEmailProviderConfigEditRequest;
import com.yd.email.feign.request.ApiEmailProviderConfigPageRequest;
import com.yd.email.feign.response.ApiEmailProviderConfigDetailResponse;
import com.yd.email.feign.response.ApiEmailProviderConfigPageResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

/**
 * SMTP邮箱服务商配置信息（存储不同邮箱服务商的SMTP配置信息）
 *
 * @author zxm
 * @since 2025-09-19
 */
@RestController
@RequestMapping("/emailProviderConfig")
@Validated
public class ApiEmailProviderConfigController implements ApiEmailProviderConfigFeignClient {

    @Autowired
    private ApiEmailProviderConfigService apiEmailProviderConfigService;

    /**
     * 分页查询-邮箱服务商
     * @param request
     * @return
     */
    @Override
    public Result<IPage<ApiEmailProviderConfigPageResponse>> page(ApiEmailProviderConfigPageRequest request) {
        return apiEmailProviderConfigService.page(request);
    }

    /**
     * 添加-邮箱服务商
     * @param request
     * @return
     */
    @Override
    public Result add(ApiEmailProviderConfigAddRequest request) {
        return apiEmailProviderConfigService.add(request);
    }

    /**
     * 编辑-邮箱服务商
     * @param request
     * @return
     */
    @Override
    public Result edit(ApiEmailProviderConfigEditRequest request) {
        return apiEmailProviderConfigService.edit(request);
    }

    /**
     * 详情-邮箱服务商
     * @param providerBizId 邮箱服务商唯一业务ID
     * @return
     */
    @Override
    public Result<ApiEmailProviderConfigDetailResponse> detail(String providerBizId) {
        return apiEmailProviderConfigService.detail(providerBizId);
    }

    /**
     * 删除-邮箱服务商
     * @param providerBizId 邮箱服务商唯一业务ID
     * @return
     */
    @Override
    public Result del(String providerBizId) {
        return apiEmailProviderConfigService.del(providerBizId);
    }
}
