package com.yd.email.feign.fallback;

import com.yd.common.result.Result;
import com.yd.email.feign.client.ApiEmailContactImportFeignClient;
import com.yd.email.feign.request.ApiEmailContactImportEditRequest;
import com.yd.email.feign.request.ApiEmailContactImportPageRequest;
import com.yd.email.feign.request.ApiEmailContactImportSelectAddRequest;
import com.yd.email.feign.response.ApiEmailContactImportResponse;
import com.yd.email.feign.response.ApiEmailContactImportSessionResponse;
import lombok.extern.slf4j.Slf4j;
import org.springframework.cloud.openfeign.FallbackFactory;
import org.springframework.stereotype.Component;

/**
 * 邮箱服务-邮件联系人导入临时表信息Feign降级处理
 */
@Slf4j
@Component
public class ApiEmailContactImportFeignFallbackFactory implements FallbackFactory<ApiEmailContactImportFeignClient> {
    @Override
    public ApiEmailContactImportFeignClient create(Throwable cause) {
        return new ApiEmailContactImportFeignClient() {
            @Override
            public Result page(ApiEmailContactImportPageRequest request) {
                return null;
            }

            @Override
            public Result add(ApiEmailContactImportSelectAddRequest request) {
                return null;
            }

            @Override
            public Result edit(ApiEmailContactImportEditRequest request) {
                return null;
            }

            @Override
            public Result<ApiEmailContactImportResponse> detail(String importBizId) {
                return null;
            }

            @Override
            public Result<ApiEmailContactImportSessionResponse> detailSessionId(String sessionId) {
                return null;
            }

            @Override
            public Result del(String importBizId) {
                return null;
            }
        };
    }
}
