package com.yd.email.api.controller;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.yd.common.result.Result;
import com.yd.email.api.service.ApiEmailSenderConfigService;
import com.yd.email.feign.client.ApiEmailSenderConfigFeignClient;
import com.yd.email.feign.request.ApiEmailSenderConfigAddRequest;
import com.yd.email.feign.request.ApiEmailSenderConfigEditRequest;
import com.yd.email.feign.request.ApiEmailSenderConfigPageRequest;
import com.yd.email.feign.response.ApiEmailSenderConfigDetailResponse;
import com.yd.email.feign.response.ApiEmailSenderConfigPageResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

/**
 * 发件人配置信息
 *
 * @author zxm
 * @since 2025-09-19
 */
@RestController
@RequestMapping("/emailSenderConfig")
@Validated
public class ApiEmailSenderConfigController implements ApiEmailSenderConfigFeignClient {

    @Autowired
    private ApiEmailSenderConfigService apiEmailSenderConfigService;

    /**
     * 分页查询-发件人
     * @param request
     * @return
     */
    @Override
    public Result<IPage<ApiEmailSenderConfigPageResponse>> page(ApiEmailSenderConfigPageRequest request) {
        return apiEmailSenderConfigService.page(request);
    }

    /**
     * 添加-发件人配置
     * @param request
     * @return
     */
    @Override
    public Result add(ApiEmailSenderConfigAddRequest request) {
        return apiEmailSenderConfigService.add(request);
    }

    /**
     * 编辑-发件人配置
     * @param request
     * @return
     */
    @Override
    public Result edit(ApiEmailSenderConfigEditRequest request) {
        return apiEmailSenderConfigService.edit(request);
    }

    /**
     * 详情-发件人
     * @param senderBizId 发件人唯一业务ID
     * @return
     */
    @Override
    public Result<ApiEmailSenderConfigDetailResponse> detail(String senderBizId) {
        return apiEmailSenderConfigService.detail(senderBizId);
    }

    /**
     * 删除-发件人
     * @param senderBizId 发件人唯一业务ID
     * @return
     */
    @Override
    public Result del(String senderBizId) {
        return apiEmailSenderConfigService.del(senderBizId);
    }
}
