package com.yd.email.feign.client;

import com.yd.common.result.Result;
import com.yd.email.feign.fallback.ApiEmailSendFeignFallbackFactory;
import com.yd.email.feign.request.ApiSendEmailRequest;
import com.yd.email.feign.response.ApiSendEmailResponse;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;

/**
 * 邮箱服务-邮件发送Feign客户端
 */
@FeignClient(name = "yd-email-api", fallbackFactory = ApiEmailSendFeignFallbackFactory.class)
public interface ApiEmailSendFeignClient {

    /**
     * 发送邮件
     * @param request
     * @return
     */
    @PostMapping("/send")
    Result<ApiSendEmailResponse> sendEmail(@Validated @RequestBody ApiSendEmailRequest request);

    /**
     * 测试发送邮件
     * @param request
     * @return
     */
    @PostMapping("/test/send")
    Result<ApiSendEmailResponse> testSendEmail(@Validated @RequestBody ApiSendEmailRequest request);
}
