package com.yd.email.service.dao;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.yd.email.feign.request.ApiEmailProviderConfigPageRequest;
import com.yd.email.feign.response.ApiEmailProviderConfigPageResponse;
import com.yd.email.service.model.EmailProviderConfig;
import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import org.apache.ibatis.annotations.Param;

/**
 * <p>
 * SMTP邮箱服务商配置表（存储不同邮箱服务商的SMTP配置信息） Mapper 接口
 * </p>
 *
 * @author zxm
 * @since 2025-09-19
 */
public interface EmailProviderConfigMapper extends BaseMapper<EmailProviderConfig> {

    IPage<ApiEmailProviderConfigPageResponse> page(@Param("page") Page<ApiEmailProviderConfigPageResponse> page,
                                                   @Param("request") ApiEmailProviderConfigPageRequest request);
}
