package com.yd.email.feign.dto;

import lombok.Data;

/**
 * 邮件发件人配置DTO
 */
@Data
public class ApiEmailSenderConfigDto {

    /**
     * 发件人唯一业务ID
     */
    private String senderBizId;

    /**
     * 发件人显示名称（姓名/昵称）
     */
    private String displayName;

    /**
     * 发件人邮箱（单个）*
     */
    private String sendEmail;

    /**
     * 发件人邮箱密码或授权码
     */
    private String password;

    /**
     * 是否启用该配置: 0-否, 1-是（字典）
     */
    private Integer active;

    /**
     * 邮箱服务商唯一业务ID
     */
    private String providerBizId;

    /**
     * 邮箱服务商名称
     */
    private String providerName;

    /**
     * 发件人邮箱-SMTP服务器地址
     */
    private String smtpHost;

    /**
     * 发件人邮箱-SMTP服务器端口
     */
    private Integer smtpPort;

    /**
     * 是否启用SSL加密: 0-否, 1-是
     */
    private Integer sslEnabled;

    /**
     * 发件人邮箱-是否设置SMTP需要身份验证 默认true
     */
    private String mailSmtpAuth;

    /**
     * 发件人邮箱-是否启用TLS加密传输 默认true
     */
    private String starttlsEnable;


}
