package com.yd.email.api.controller;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.yd.common.result.Result;
import com.yd.email.api.service.ApiEmailVariableService;
import com.yd.email.feign.client.ApiEmailVariableFeignClient;
import com.yd.email.feign.request.ApiEmailVariableAddRequest;
import com.yd.email.feign.request.ApiEmailVariableEditRequest;
import com.yd.email.feign.request.ApiEmailVariablePageRequest;
import com.yd.email.feign.response.ApiEmailVariableDetailResponse;
import com.yd.email.feign.response.ApiEmailVariablePageResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

/**
 * 变量信息（邮件内容占位符）
 *
 * @author zxm
 * @since 2025-09-19
 */
@RestController
@RequestMapping("/emailVariable")
@Validated
public class ApiEmailVariableController implements ApiEmailVariableFeignClient {

    @Autowired
    private ApiEmailVariableService apiEmailVariableService;

    /**
     * 分页查询-变量
     * @param request
     * @return
     */
    @Override
    public Result<IPage<ApiEmailVariablePageResponse>> page(ApiEmailVariablePageRequest request) {
        return apiEmailVariableService.page(request);
    }

    /**
     * 添加-变量
     * @param request
     * @return
     */
    @Override
    public Result add(ApiEmailVariableAddRequest request) {
        return apiEmailVariableService.add(request);
    }

    /**
     * 编辑-变量
     * @param request
     * @return
     */
    @Override
    public Result edit(ApiEmailVariableEditRequest request) {
        return apiEmailVariableService.edit(request);
    }

    /**
     * 详情-变量
     * @param variableBizId 变量唯一业务ID
     * @return
     */
    @Override
    public Result<ApiEmailVariableDetailResponse> detail(String variableBizId) {
        return apiEmailVariableService.detail(variableBizId);
    }

    /**
     * 删除-变量
     * @param variableBizId 变量唯一业务ID
     * @return
     */
    @Override
    public Result del(String variableBizId) {
        return apiEmailVariableService.del(variableBizId);
    }
}
