package com.yd.email.feign.client;

import com.yd.common.result.Result;
import com.yd.email.feign.fallback.ApiEmailTaskRecipientsFeignFallbackFactory;
import com.yd.email.feign.request.ApiEmailTaskRecipientsPageRequest;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;

/**
 * 邮箱服务-邮件任务收件人信息Feign客户端
 */
@FeignClient(name = "yd-email-api", fallbackFactory = ApiEmailTaskRecipientsFeignFallbackFactory.class)
public interface ApiEmailTaskRecipientsFeignClient {

    /**
     * 分页查询-邮件收件人任务（支线任务）
     * @param request
     * @return
     */
    @PostMapping("/page")
    Result page(@RequestBody ApiEmailTaskRecipientsPageRequest request);

}
