package com.yd.email.service.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.yd.email.feign.request.ApiEmailContactPageRequest;
import com.yd.email.feign.response.ApiEmailContactPageResponse;
import com.yd.email.service.dto.EmailContactDto;
import com.yd.email.service.model.EmailContact;
import com.yd.email.service.dao.EmailContactMapper;
import com.yd.email.service.model.EmailSenderConfig;
import com.yd.email.service.service.IEmailContactService;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

import java.util.List;

/**
 * <p>
 * 联系人表（存储收件人信息） 服务实现类
 * </p>
 *
 * @author zxm
 * @since 2025-09-19
 */
@Service
public class EmailContactServiceImpl extends ServiceImpl<EmailContactMapper, EmailContact> implements IEmailContactService {

    @Override
    public IPage<ApiEmailContactPageResponse> page(Page<ApiEmailContactPageResponse> page,
                                                   ApiEmailContactPageRequest request) {
        return baseMapper.page(page,request);
    }

    /**
     * 查询列表
     * @param dto
     * @return
     */
    @Override
    public List<EmailContact> queryList(EmailContactDto dto) {
        List<EmailContact> list = baseMapper.selectList(new LambdaQueryWrapper<EmailContact>()
                .eq(StringUtils.isNotBlank(dto.getContactBizId()) && !dto.getIsExcludeMy(),EmailContact::getContactBizId,dto.getContactBizId())
                .eq(StringUtils.isNotBlank(dto.getEmail()),EmailContact::getEmail,dto.getEmail())
                .in(!CollectionUtils.isEmpty(dto.getEmailList()),EmailContact::getEmail,dto.getEmailList())
                .ne(dto.getIsExcludeMy(),EmailContact::getContactBizId,dto.getContactBizId())
        );
        return list;
    }

    /**
     * 查询单个对象
     * @param contactBizId
     * @return
     */
    @Override
    public EmailContact queryOne(String contactBizId) {
        return this.getOne(new LambdaQueryWrapper<EmailContact>()
                .eq(EmailContact::getContactBizId,contactBizId));
    }

}
