package com.yd.email.api.controller;

import com.yd.common.result.Result;
import com.yd.email.api.service.ApiEmailFileService;
import com.yd.email.feign.client.ApiEmailFileFeignClient;
import com.yd.email.feign.request.ApiExportVariableExcelRequest;
import com.yd.email.feign.response.ApiExportVariableExcelResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

/**
 * 邮件文件信息
 *
 * @author zxm
 * @since 2025-09-25
 */
@RestController
@RequestMapping("/emailFile")
@Validated
public class ApiEmailFileController implements ApiEmailFileFeignClient {

    @Autowired
    private ApiEmailFileService apiEmailFileService;

    /**
     * 导出-变量excel
     * @param request
     * @return
     */
    @Override
    public Result<ApiExportVariableExcelResponse> exportVariableExcel(ApiExportVariableExcelRequest request) {
        return apiEmailFileService.exportVariableExcel(request);
    }
}
