package com.yd.email.feign.fallback;

import com.yd.common.result.Result;
import com.yd.email.feign.client.ApiEmailFileFeignClient;
import com.yd.email.feign.request.ApiExportVariableExcelRequest;
import com.yd.email.feign.response.ApiExportVariableExcelResponse;
import lombok.extern.slf4j.Slf4j;
import org.springframework.cloud.openfeign.FallbackFactory;
import org.springframework.stereotype.Component;

/**
 * 邮箱服务-邮件文件信息Feign降级处理
 */
@Slf4j
@Component
public class ApiEmailFileFeignFallbackFactory implements FallbackFactory<ApiEmailFileFeignClient> {
    @Override
    public ApiEmailFileFeignClient create(Throwable cause) {
        return new ApiEmailFileFeignClient() {
            @Override
            public Result<ApiExportVariableExcelResponse> exportVariableExcel(ApiExportVariableExcelRequest request) {
                return null;
            }
        };
    }
}
