package com.yd.email.feign.fallback;

import com.yd.common.result.Result;
import com.yd.email.feign.client.ApiEmailTaskRecipientsFeignClient;
import com.yd.email.feign.request.ApiEmailTaskRecipientsPageRequest;
import lombok.extern.slf4j.Slf4j;
import org.springframework.cloud.openfeign.FallbackFactory;
import org.springframework.stereotype.Component;

/**
 * 邮箱服务-邮件任务收件人信息Feign降级处理
 */
@Slf4j
@Component
public class ApiEmailTaskRecipientsFeignFallbackFactory implements FallbackFactory<ApiEmailTaskRecipientsFeignClient> {
    @Override
    public ApiEmailTaskRecipientsFeignClient create(Throwable cause) {
        return new ApiEmailTaskRecipientsFeignClient() {
            @Override
            public Result page(ApiEmailTaskRecipientsPageRequest request) {
                return null;
            }
        };
    }
}
