package com.yd.email.api.service.impl;

import com.yd.common.result.Result;
import com.yd.email.api.service.ApiEmailFileService;
import com.yd.email.api.service.ApiEmailVariableGroupService;
import com.yd.email.feign.dto.ApiEmailVariableDto;
import com.yd.email.feign.request.ApiExportVariableExcelRequest;
import com.yd.email.feign.request.ApiImportVariableExcelRequest;
import com.yd.email.feign.response.ApiEmailVariableGroupDetailResponse;
import com.yd.email.feign.response.ApiExportVariableExcelResponse;
import com.yd.email.feign.response.ApiImportVariableExcelResponse;
import com.yd.oss.feign.client.ApiExcelFeignClient;
import com.yd.oss.feign.dto.ExportParam;
import com.yd.oss.feign.dto.ExportResult;
import com.yd.oss.feign.request.ApiExportRequest;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.web.multipart.MultipartFile;

import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;

@Slf4j
@Service
public class ApiEmailFileServiceImpl implements ApiEmailFileService {

    @Autowired
    private ApiExcelFeignClient apiExcelFeignClient;

    @Autowired
    private ApiEmailVariableGroupService apiEmailVariableGroupService;

    /**
     * 导出-变量excel
     * @param request
     * @return
     */
    @Override
    public Result<ApiExportVariableExcelResponse> exportVariableExcel(ApiExportVariableExcelRequest request) {
        Result<ApiEmailVariableGroupDetailResponse> result = apiEmailVariableGroupService.detail(request.getVariableGroupBizId());
        ApiEmailVariableGroupDetailResponse response = result.getData();
        //分组绑定的变量列表
        List<ApiEmailVariableDto> emailVariableDtoList = response.getEmailVariableDtoList();
        List<String> FieldNameList = Arrays.asList("联系人", "邮箱", "抄送人");
        if (!CollectionUtils.isEmpty(emailVariableDtoList)) {
            FieldNameList.addAll(emailVariableDtoList.stream().map(ApiEmailVariableDto::getVariableNameCn).collect(Collectors.toList()));
        }

        //构建导出参数
        ExportParam exportParam = new ExportParam();
        exportParam.setFileName("变量"); // 基础文件名
        exportParam.setFieldNames(FieldNameList); // 要导出的字段
        exportParam.setUploadToOss(true); // 设置为true表示上传到OSS
        ApiExportRequest exportRequest = new ApiExportRequest();
        exportRequest.setExportParam(exportParam);
        //远程调用OSS的Feign，通用-Excel导出参数（如果传dataList附加数据，不传单纯导出表头参数）
        Result<ExportResult> resultResult = apiExcelFeignClient.export(exportRequest);
        ApiExportVariableExcelResponse response1 = new ApiExportVariableExcelResponse();
        if (!Objects.isNull(resultResult.getData())) {
            response1.setUrl(resultResult.getData().getOssUrl());
        }
        return Result.success(response1);
    }

    /**
     * 导入-变量excel
     * @param file
     * @param request
     * @return
     */
    @Override
    public Result<ApiImportVariableExcelResponse> importVariableExcel(MultipartFile file,
                                                                      ApiImportVariableExcelRequest request) {
        return null;
    }

}
