package com.yd.email.feign.request;

import com.yd.common.dto.PageDto;
import lombok.Data;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;

@Data
public class ApiEmailContactImportPageRequest extends PageDto {

    /**
     * 收件人邮箱（单个）
     */
    private String receiveEmail;

    /**
     * 当前会话id
     */
    @NotBlank(message = "会话id不能为空")
    private String sessionId;

    /**
     * 导入数据的来源 0-选择联系人导入 1-excel导入联系人
     */
    @NotNull(message = "导入数据的来源不能为空")
    private Integer source;
}
