package com.yd.email.api.controller;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.yd.common.result.Result;
import com.yd.email.api.service.ApiEmailTaskService;
import com.yd.email.feign.client.ApiEmailTaskFeignClient;
import com.yd.email.feign.request.ApiEmailTaskPageRequest;
import com.yd.email.feign.response.ApiEmailTaskPageResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

/**
 * 邮件任务信息（存储邮件发送任务信息）
 *
 * @author zxm
 * @since 2025-09-19
 */
@RestController
@RequestMapping("/emailTask")
@Validated
public class ApiEmailTaskController implements ApiEmailTaskFeignClient {

    @Autowired
    private ApiEmailTaskService apiEmailTaskService;

    /**
     * 分页查询-邮件任务（主线任务）
     * @param request
     * @return
     */
    @Override
    public Result<IPage<ApiEmailTaskPageResponse>> page(ApiEmailTaskPageRequest request) {
        return apiEmailTaskService.page(request);
    }

}
