package com.yd.email.api.controller;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.yd.common.result.Result;
import com.yd.email.api.service.ApiEmailTaskRecipientsService;
import com.yd.email.feign.client.ApiEmailTaskRecipientsFeignClient;
import com.yd.email.feign.request.ApiEmailTaskRecipientsPageRequest;
import com.yd.email.feign.response.ApiEmailTaskRecipientsPageResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

/**
 * 邮件任务收件人信息
 *
 * @author zxm
 * @since 2025-09-19
 */
@RestController
@RequestMapping("/emailTaskRecipients")
@Validated
public class ApiEmailTaskRecipientsController implements ApiEmailTaskRecipientsFeignClient {

    @Autowired
    private ApiEmailTaskRecipientsService apiEmailTaskRecipientsService;

    /**
     * 分页查询-邮件收件人任务（支线任务）
     * @param request
     * @return
     */
    @Override
    public Result<IPage<ApiEmailTaskRecipientsPageResponse>> page(ApiEmailTaskRecipientsPageRequest request) {
        return apiEmailTaskRecipientsService.page(request);
    }

}
