package com.yd.email.api.controller;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.yd.common.result.Result;
import com.yd.email.api.service.ApiEmailVariableGroupService;
import com.yd.email.feign.client.ApiEmailVariableGroupFeignClient;
import com.yd.email.feign.request.ApiEmailVariableGroupAddRequest;
import com.yd.email.feign.request.ApiEmailVariableGroupEditRequest;
import com.yd.email.feign.request.ApiEmailVariableGroupPageRequest;
import com.yd.email.feign.response.ApiEmailVariableGroupDetailResponse;
import com.yd.email.feign.response.ApiEmailVariableGroupPageResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

/**
 * 变量分组信息
 *
 * @author zxm
 * @since 2025-09-22
 */
@RestController
@RequestMapping("/emailVariableGroup")
@Validated
public class ApiEmailVariableGroupController implements ApiEmailVariableGroupFeignClient {

    @Autowired
    private ApiEmailVariableGroupService apiEmailVariableGroupService;

    /**
     * 分页查询-变量分组
     * @param request
     * @return
     */
    @Override
    public Result<IPage<ApiEmailVariableGroupPageResponse>> page(ApiEmailVariableGroupPageRequest request) {
        return apiEmailVariableGroupService.page(request);
    }

    /**
     * 添加-变量分组
     * @param request
     * @return
     */
    @Override
    public Result add(ApiEmailVariableGroupAddRequest request) {
        return apiEmailVariableGroupService.add(request);
    }

    /**
     * 编辑-变量分组
     * @param request
     * @return
     */
    @Override
    public Result edit(ApiEmailVariableGroupEditRequest request) {
        return apiEmailVariableGroupService.edit(request);
    }

    /**
     * 详情-变量分组
     * @param variableGroupBizId 变量分组唯一业务ID
     * @return
     */
    @Override
    public Result<ApiEmailVariableGroupDetailResponse> detail(String variableGroupBizId) {
        return apiEmailVariableGroupService.detail(variableGroupBizId);
    }

    /**
     * 删除-变量分组
     * @param variableGroupBizId 变量分组唯一业务ID
     * @return
     */
    @Override
    public Result del(String variableGroupBizId) {
        return apiEmailVariableGroupService.del(variableGroupBizId);
    }
}
