package com.yd.email.api.service.impl;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.yd.common.result.Result;
import com.yd.email.api.service.ApiEmailTaskRecipientsService;
import com.yd.email.feign.request.ApiEmailTaskRecipientsPageRequest;
import com.yd.email.feign.response.ApiEmailTaskPageResponse;
import com.yd.email.feign.response.ApiEmailTaskRecipientsPageResponse;
import com.yd.email.service.dto.EmailContactImportDto;
import com.yd.email.service.model.EmailContactImport;
import com.yd.email.service.model.EmailTaskRecipients;
import com.yd.email.service.service.IEmailContactImportService;
import com.yd.email.service.service.IEmailTaskRecipientsService;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;

/**
 * 邮件任务收件人实现类
 */
@Service
@Slf4j
public class ApiEmailTaskRecipientsServiceImpl implements ApiEmailTaskRecipientsService {

    @Autowired
    private IEmailContactImportService iEmailContactImportService;

    @Autowired
    private IEmailTaskRecipientsService iEmailTaskRecipientsService;

    /**
     * 分页查询-邮件收件人任务（支线任务）
     * @param request
     * @return
     */
    @Override
    public Result<IPage<ApiEmailTaskRecipientsPageResponse>> page(ApiEmailTaskRecipientsPageRequest request) {
        Page<ApiEmailTaskRecipientsPageResponse> page = new Page<>(request.getPageNo(), request.getPageSize());
        IPage<ApiEmailTaskRecipientsPageResponse> iPage = iEmailTaskRecipientsService.page(page, request);
        return Result.success(iPage);
    }

    /**
     * 根据当前当前会话id和数据来源查询导入数据，保存到邮件任务收件人关联表中
     * @param taskBizId 邮件任务唯一业务ID
     * @param status 收件人邮件状态
     * @param sessionId 会话id
     * @param source 数据的来源 0-选择联系人导入 1-excel导入联系人
     * @return
     */
    @Override
    public Result<List<EmailTaskRecipients>> saveEmailTaskRecipientsBySessionId(String taskBizId,String status,
                                                     String sessionId,Integer source) {
        //根据当前当前会话id和数据来源查询的导入数据
        List<EmailContactImport> emailContactImportList = iEmailContactImportService.queryList(EmailContactImportDto
                .builder()
                .sessionId(sessionId)
                .source(source)
                .build());
        List<EmailTaskRecipients> saveRecipientsList = new ArrayList<>();
        if (!CollectionUtils.isEmpty(emailContactImportList)) {
            //不为空，保存到邮件任务收件人关联表中
            saveRecipientsList = emailContactImportList
                    .stream()
                    .map(dto -> {
                        EmailTaskRecipients recipient = new EmailTaskRecipients();
                        BeanUtils.copyProperties(dto,recipient);
                        recipient.setTaskBizId(taskBizId);
                        recipient.setStatus(status);
                        return recipient;
                    }).collect(Collectors.toList());
            //保存到邮件任务收件人关联表中
            iEmailTaskRecipientsService.saveOrUpdateBatch(saveRecipientsList);
        }

        return Result.success(saveRecipientsList);
    }
}
