package com.yd.email.feign.client;

import com.yd.common.result.Result;
import com.yd.email.feign.fallback.ApiEmailContactFeignFallbackFactory;
import com.yd.email.feign.request.ApiEmailContactAddRequest;
import com.yd.email.feign.request.ApiEmailContactEditRequest;
import com.yd.email.feign.request.ApiEmailContactPageRequest;
import com.yd.email.feign.response.ApiEmailContactDetailResponse;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.*;

/**
 * 邮箱服务-联系人信息（存储联系人（收件人）信息）Feign客户端
 */
@FeignClient(name = "yd-email-api", fallbackFactory = ApiEmailContactFeignFallbackFactory.class)
public interface ApiEmailContactFeignClient {

    /**
     * 分页查询-联系人（收件人）
     * @param request
     * @return
     */
    @PostMapping("/page")
    Result page(@RequestBody ApiEmailContactPageRequest request);

    /**
     * 添加-联系人（收件人）配置
     * @param request
     * @return
     */
    @PostMapping("/add")
    Result add(@Validated @RequestBody ApiEmailContactAddRequest request);

    /**
     * 编辑-联系人（收件人）配置
     * @param request
     * @return
     */
    @PutMapping("/edit")
    Result edit(@Validated @RequestBody ApiEmailContactEditRequest request);

    /**
     * 详情-联系人（收件人）
     * @param contactBizId 联系人（收件人）唯一业务ID
     * @return
     */
    @GetMapping("/detail")
    Result<ApiEmailContactDetailResponse> detail(@RequestParam(value = "contactBizId") String contactBizId);

    /**
     * 删除-联系人（收件人）
     * @param contactBizId 联系人（收件人）唯一业务ID
     * @return
     */
    @DeleteMapping("/del")
    Result del(@RequestParam(value = "contactBizId") String contactBizId);
}
