package com.yd.email.feign.client;

import com.yd.common.result.Result;
import com.yd.email.feign.fallback.ApiEmailTaskFeignFallbackFactory;
import com.yd.email.feign.request.ApiEmailTaskPageRequest;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;

/**
 * 邮箱服务-邮件任务信息（存储邮件发送任务信息）Feign客户端
 */
@FeignClient(name = "yd-email-api", fallbackFactory = ApiEmailTaskFeignFallbackFactory.class)
public interface ApiEmailTaskFeignClient {

    /**
     * 分页查询-邮件任务（主线任务）
     * @param request
     * @return
     */
    @PostMapping("/page")
    Result page(@RequestBody ApiEmailTaskPageRequest request);

}
