package com.yd.email.feign.dto;

import lombok.Data;
import java.util.List;

/**
 * 调用邮件服务发送邮件入参DTO
 */
@Data
public class ApiSendMailDto {

    /**
     * 邮件主题 *
     */
    private String subject;

    /**
     * 邮件内容 *
     */
    private String content;

    /**
     * 发送邮件的附件路径（多个用分号分隔）*
     */
    private String attachmentPath;

    /**
     * 收件人邮箱（单个）
     */
    private String receiveEmail;

    /**
     * 抄送人邮箱列表
     */
    private List<String> ccEmailList;

    /**
     * 发件人邮箱（单个）*
     */
    private String sendEmail;

    /**
     * 发件人邮箱密码或授权码
     */
    private String password;

    /**
     * 发件人邮箱-是否设置SMTP需要身份验证 默认true
     */
    private String mailSmtpAuth;

    /**
     * 发件人邮箱-是否启用TLS加密传输 默认true
     */
    private String starttlsEnable;

    /**
     * 发件人邮箱-SMTP服务器地址
     */
    private String smtpHost;

    /**
     * 发件人邮箱-SMTP服务器端口
     */
    private Integer smtpPort;


}
